<?php
require_once __DIR__ . '/../config.php';
rp_require_login();
?>
<!DOCTYPE html>
<html lang="nl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Mijn/Teamrooster – Roosterprogramma</title>
  <link rel="stylesheet" href="style.css">
</head>
<body>
  <header class="topbar">
    <div class="brand"><a href="/app/dashboard/" class="back">←</a> Rooster</div>
    <nav class="nav">
      <a href="/app/roster/" class="navlink active">Bekijken</a>
      <a href="/app/availability/" class="navlink">Mijn beschikbaarheid</a>
      <a href="/app/profile/" class="navlink">Mijn profiel</a>
      <a href="/api/auth/logout.php" class="navlink">Log uit</a>
    </nav>
  </header>

  <main class="wrap">
    <section class="card">
      <div class="controls">
        <div class="weeknav">
          <button id="prevWeek" class="btn small">◀</button>
          <span id="rangeLabel" class="range"></span>
          <button id="nextWeek" class="btn small">▶</button>
        </div>
        <div class="filters">
          <label class="check"><input type="checkbox" id="mineOnly"> Alleen mijn diensten</label>
          <div id="deptChecks" class="checks"></div>
        </div>
      </div>
      <div class="gridwrap">
        <table id="rosterGrid" class="grid">
          <!-- dynamisch -->
        </table>
      </div>
      <p class="legend">Kleuren = afdelingen. Week loopt van maandag t/m zondag.</p>
    </section>
  </main>

  <script src="app.js"></script>
</body>
</html>
