'use strict';

(async function(){
  const sel = (q)=>document.querySelector(q);
  const form = sel('#onbForm');
  const first = sel('#first');
  const last  = sel('#last');
  const list  = sel('#deptList');
  const note  = sel('#note');
  const deptHelp = sel('#deptHelp');

  // Laad afdelingen
  try {
    const res = await fetch('/api/departments/list.php');
    const data = await res.json();
    if (data.ok && data.items.length) {
      list.innerHTML = '';
      data.items.forEach(d => {
        const id = `dept_${d.id}`;
        const wrap = document.createElement('label');
        wrap.className = 'check';
        wrap.innerHTML = `
          <input type="checkbox" value="${d.id}" id="${id}">
          <span>${d.name}</span>
        `;
        list.appendChild(wrap);
      });
      deptHelp.textContent = 'Kies minimaal één afdeling.';
    } else {
      deptHelp.textContent = 'Nog geen afdelingen beschikbaar. Vraag een manager om er één aan te maken.';
    }
  } catch(_) { deptHelp.textContent = 'Kon afdelingen niet laden.'; }

  function show(msg){ note.hidden=false; note.textContent=msg; }

  form.addEventListener('submit', async (e) => {
    e.preventDefault();
    note.hidden = true;

    const firstVal = first.value.trim();
    const lastVal  = last.value.trim();
    const checked = Array.from(list.querySelectorAll('input[type="checkbox"]:checked')).map(i=>parseInt(i.value,10));

    if (!firstVal || !lastVal || checked.length < 1) {
      return show('Vul je voornaam, achternaam in en kies minimaal één afdeling.');
    }

    try {
      const res = await fetch('/api/user/update-profile.php', {
        method:'POST', headers:{'Content-Type':'application/json'},
        body: JSON.stringify({ first_name:firstVal, last_name:lastVal, department_ids:checked })
      });
      const data = await res.json();
      if (!res.ok || data.ok === false) throw new Error(data?.error || 'Opslaan mislukt');

      try { sessionStorage.setItem('rp_welcome', JSON.stringify({ msg: `Welkom, ${firstVal}!`, ts: Date.now() })); } catch(_){}

      window.location.href = '/app/dashboard/';
    } catch (err) {
      show(err.message || 'Opslaan mislukt');
    }
  });
})();
