<?php
require_once __DIR__ . '/../config.php';
rp_require_login(['admin','manager']); // alleen roostermakers
?>
<!DOCTYPE html>
<html lang="nl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Beschikbaarheid – Overzicht</title>
  <link rel="stylesheet" href="overview.css">
</head>
<body>
  <header class="topbar">
    <div class="brand">
      <a class="back" href="/app/dashboard" title="Terug">←</a>
      Beschikbaarheid – Overzicht
    </div>
    <nav class="nav">
      <a class="navlink" href="/app/roster/manage.php">Rooster maken</a>
      <a class="navlink" href="/app/roster/">Rooster bekijken</a>
      <a class="navlink" href="/app/profile/">Mijn profiel</a>
      <a class="navlink" href="/api/auth/logout.php">Log uit</a>
    </nav>
  </header>

  <main class="wrap">
    <section class="card filters">
      <div class="row">
        <div class="field">
          <label>Afdelingen</label>
          <div id="deptChecks" class="checks"></div>
        </div>
        <div class="field">
          <label>Zoek medewerker</label>
          <input id="q" type="search" placeholder="Naam of e-mail…" />
        </div>
        <div class="actions">
          <button id="resetBtn" class="btn ghost">Reset</button>
          <button id="reloadBtn" class="btn primary">Vernieuwen</button>
        </div>
      </div>
      <small class="muted">Week loopt van <b>maandag</b> t/m <b>zondag</b>.</small>
    </section>

    <section class="card">
      <div class="gridHead">
        <div class="colUser">Medewerker</div>
        <div class="colDay">Ma</div>
        <div class="colDay">Di</div>
        <div class="colDay">Wo</div>
        <div class="colDay">Do</div>
        <div class="colDay">Vr</div>
        <div class="colDay">Za</div>
        <div class="colDay">Zo</div>
      </div>
      <div id="list" class="gridList"></div>
      <div id="empty" class="empty" hidden>Geen medewerkers gevonden voor de huidige filters.</div>
    </section>
  </main>

  <script src="overview.js"></script>
</body>
</html>
