<?php
require_once __DIR__ . '/../config.php';
rp_require_login(['admin','manager']);
?>
<!doctype html>
<html lang="nl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Acties & Meldingen beheren</title>
  <link rel="stylesheet" href="manage.css">
</head>
<body>
  <header class="topbar">
    <div class="brand"><a class="back" href="/app/dashboard/">←</a> Acties & Meldingen</div>
    <nav class="nav">
      <a class="navlink" href="/app/availability/overview.php">Beschikbaarheid</a>
      <a class="navlink" href="/app/roster/manage.php">Rooster</a>
      <a class="navlink" href="/api/auth/logout.php">Uitloggen</a>
    </nav>
  </header>

  <main class="wrap">
    <section class="card">
      <h3 style="margin:0 0 8px">Nieuwe / bewerken</h3>
      <form id="frm" class="form" novalidate>
        <input type="hidden" id="id">
        <div class="grid">
          <div class="field">
            <label>Type</label>
            <select id="type" required>
              <option value="activity">Activiteit</option>
              <option value="notice">Melding</option>
              <option value="special">Speciale actie</option>
            </select>
          </div>
          <div class="field">
            <label>Bereik</label>
            <select id="scope">
              <option value="global">Iedereen</option>
              <option value="department">Per afdeling</option>
              <option value="user">Specifieke persoon</option>
            </select>
          </div>
          <div class="field"><label>Start</label><input type="datetime-local" id="start"></div>
          <div class="field"><label>Einde</label><input type="datetime-local" id="end"></div>
        </div>

        <div class="field"><label>Titel</label><input id="title" maxlength="160" placeholder="Korte titel…"></div>
        <div class="field"><label>Omschrijving</label><textarea id="message" rows="3" placeholder="Extra tekst (optioneel)"></textarea></div>

        <div id="scopeDept" class="field" hidden>
          <label>Afdelingen (meerdere toegestaan)</label>
          <div id="deptChecks" class="checks"></div>
        </div>
        <div id="scopeUser" class="field" hidden>
          <label>Medewerkers (meerdere toegestaan)</label>
          <input id="userSearch" class="search" placeholder="Zoek naam of e-mail…">
          <div id="userList" class="list"></div>
        </div>

        <div class="actions">
          <button class="btn" id="save">Opslaan</button>
          <button class="btn ghost" id="reset">Leeg</button>
        </div>
        <div id="msg" class="note" hidden></div>
      </form>
    </section>

    <section class="card">
      <div class="row">
        <div class="field">
          <label>Filter type</label>
          <select id="fltType">
            <option value="">Alle</option>
            <option value="activity">Activiteit</option>
            <option value="notice">Melding</option>
            <option value="special">Speciale actie</option>
          </select>
        </div>
        <div class="field">
          <label>Alleen actief</label>
          <select id="fltActive">
            <option value="">Alles</option>
            <option value="1">Ja</option>
            <option value="0">Nee</option>
          </select>
        </div>
        <div class="field">
          <label>Afdeling</label>
          <select id="fltDept"><option value="0">Alle</option></select>
        </div>
        <div class="actions">
          <button class="btn primary" id="reload">Vernieuwen</button>
        </div>
      </div>

      <div id="table" class="table"></div>
    </section>
  </main>

  <script src="manage.js"></script>
</body>
</html>
