<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login();

$u = rp_user();
$id = (int)$u['id'];

$stmt = $pdo->prepare('SELECT id, email, full_name, role, department_id, phone FROM users WHERE id = ? LIMIT 1');
$stmt->execute([$id]);
$user = $stmt->fetch();
if (!$user) rp_json(['ok'=>false,'error'=>'User niet gevonden'], 404);

$first = ''; $last = '';
if (!empty($user['full_name'])) {
  $parts = preg_split('/\s+/', trim($user['full_name']), 2);
  $first = $parts[0] ?? '';
  $last  = $parts[1] ?? '';
} else {
  $first = rp_first_name($user['email']);
}

$deps = $pdo->prepare('SELECT department_id FROM user_departments WHERE user_id = ? ORDER BY department_id');
$deps->execute([$id]);
$department_ids = array_map('intval', $deps->fetchAll(PDO::FETCH_COLUMN));

rp_json(['ok'=>true, 'user'=>[
  'id' => (int)$user['id'],
  'email' => $user['email'],
  'role' => $user['role'] ?: 'member',
  'first_name' => $first,
  'last_name' => $last,
  'phone' => $user['phone'],
  'department_id' => $user['department_id'],
  'department_ids' => $department_ids
]]);
