<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login(['admin','manager']);

$in = rp_json_input();
$rosterId = (int)($in['roster_id'] ?? 0);
$shifts   = is_array($in['shifts'] ?? null) ? $in['shifts'] : [];
if (empty($shifts)) rp_json(['ok'=>true,'conflicts'=>[],'warnings'=>[]]);

// Namen
$uids = [];
foreach ($shifts as $s) foreach (($s['user_ids'] ?? []) as $uid) $uids[(int)$uid]=true;
$names = [];
if ($uids){
  $ph = implode(',', array_fill(0, count($uids), '?'));
  $stm = $pdo->prepare("SELECT id, COALESCE(full_name,email) name FROM users WHERE id IN ($ph)");
  $stm->execute(array_keys($uids));
  foreach ($stm->fetchAll() as $r) $names[(int)$r['id']] = $r['name'];
}

// Business hours
$deptIds = [];
foreach ($shifts as $s) $deptIds[(int)$s['department_id']] = true;
$bh = [];
if ($deptIds) {
  $ph = implode(',', array_fill(0, count($deptIds), '?'));
  $stm = $pdo->prepare("SELECT department_id, weekday, is_closed, open_time, close_time FROM business_hours WHERE department_id IN ($ph)");
  $stm->execute(array_keys($deptIds));
  foreach ($stm->fetchAll() as $r) {
    $d=(int)$r['department_id']; $w=(int)$r['weekday'];
    $bh[$d][$w] = ['open'=>$r['open_time']?:'09:00:00','close'=>$r['close_time']?:'18:00:00','closed'=>(int)$r['is_closed']===1];
  }
}

$conflicts = [];
// 1) Overlap + multi-per-dag binnen payload
$byUserDay = []; // [uid][Y-m-d] => [[a,b,dept]]
foreach ($shifts as $s){
  $date = substr($s['start_at'],0,10);
  $a = strtotime($s['start_at']); $b = strtotime($s['end_at']);
  foreach (($s['user_ids'] ?? []) as $uid){
    $byUserDay[$uid][$date] = $byUserDay[$uid][$date] ?? [];
    $byUserDay[$uid][$date][] = [$a,$b,(int)$s['department_id']];
  }
}
foreach ($byUserDay as $uid=>$days){
  foreach ($days as $date=>$arr){
    usort($arr, fn($x,$y)=>$x[0]<=>$y[0]);
    if (count($arr) > 1) {
      $conflicts[] = [
        'type'=>'multi','user_id'=>(int)$uid,'user_name'=>$names[(int)$uid] ?? ('#'.$uid),
        'date'=>$date,'details'=>'Meerdere diensten op dezelfde dag'
      ];
    }
    for ($i=1;$i<count($arr);$i++){
      [$pa,$pb] = $arr[$i-1]; [$a,$b] = $arr[$i];
      if ($a < $pb){
        $conflicts[] = [
          'type'=>'overlap','user_id'=>(int)$uid,'user_name'=>$names[(int)$uid] ?? ('#'.$uid),
          'date'=>$date,'start_at'=>date('H:i',$a),'end_at'=>date('H:i',$b),'details'=>'Overlap binnen ingestuurde diensten'
        ];
      }
    }
  }
}
// 2) Overlap met bestaande DB (zelfde als eerder)
if (!empty($uids)){
  $startMin = min(array_map(fn($s)=>$s['start_at'],$shifts));
  $endMax   = max(array_map(fn($s)=>$s['end_at'],  $shifts));
  $phU = implode(',', array_fill(0, count($uids), '?'));
  $params = array_merge([$endMax, $startMin], array_keys($uids));
  $sql = "SELECT sa.user_id, s.start_at, s.end_at, DATE(s.start_at) as day
          FROM shifts s
          JOIN shift_assignments sa ON sa.shift_id=s.id
          WHERE s.start_at <= ? AND s.end_at >= ? AND sa.user_id IN ($phU)";
  if ($rosterId>0) $sql .= " AND s.roster_id <> ".((int)$rosterId);
  $stm = $pdo->prepare($sql); $stm->execute($params);
  $existing = [];
  foreach ($stm->fetchAll() as $r){
    $existing[(int)$r['user_id']][] = [strtotime($r['start_at']), strtotime($r['end_at']), $r['day']];
  }
  foreach ($shifts as $s){
    $a=strtotime($s['start_at']); $b=strtotime($s['end_at']); $date=substr($s['start_at'],0,10);
    foreach (($s['user_ids'] ?? []) as $uid){
      // multi-per-dag t.o.v. DB
      $dbSameDay = array_filter(($existing[$uid] ?? []), fn($x)=> $x[2]===$date);
      if ($dbSameDay) {
        $conflicts[] = ['type'=>'multi','user_id'=>(int)$uid,'user_name'=>$names[(int)$uid] ?? ('#'.$uid),'date'=>$date,'details'=>'Deze medewerker heeft al een dienst (DB) op deze dag'];
      }
      foreach (($existing[$uid] ?? []) as [$x,$y]){
        if ($a < $y && $b > $x){
          $conflicts[] = ['type'=>'overlap','user_id'=>(int)$uid,'user_name'=>$names[(int)$uid] ?? ('#'.$uid),'date'=>$date,'details'=>'Overlap met bestaande dienst in database'];
        }
      }
    }
  }
}
// 3) Business hours
foreach ($shifts as $s){
  $w = (int)date('N', strtotime($s['start_at']));
  $dept = (int)$s['department_id'];
  $date = substr($s['start_at'],0,10);
  $row = $bh[$dept][$w] ?? null; if (!$row) continue;
  $open = $row['open']; $close = $row['close']; $closed = $row['closed'];
  $a=strtotime($s['start_at']); $b=strtotime($s['end_at']); $oa=strtotime("$date $open"); $ob=strtotime("$date $close");
  if ($closed || $a < $oa || $b > $ob){
    $conflicts[] = ['type'=>'business_hours','date'=>$date,'start_at'=>substr($s['start_at'],11,5),'end_at'=>substr($s['end_at'],11,5),'details'=>"Buiten openingstijden ($open–$close) of gesloten"];
  }
}

rp_json(['ok'=>true,'conflicts'=>$conflicts,'warnings'=>[]]);
