<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login(); // iedereen mag z'n eigen items zien

$uid = (int)($_SESSION['user']['id'] ?? 0);
if ($uid<=0) rp_json(['ok'=>true,'items'=>['activity'=>[],'notice'=>[],'special'=>[]]]);

$sql = "SELECT a.*
        FROM announcements a
        WHERE (a.start_at IS NULL OR a.start_at <= NOW())
          AND (a.end_at   IS NULL OR a.end_at   >= NOW())
          AND (
             a.scope='global'
             OR (a.scope='user' AND EXISTS(SELECT 1 FROM announcement_users au WHERE au.announcement_id=a.id AND au.user_id=?))
             OR (a.scope='department' AND EXISTS(
                    SELECT 1 FROM announcement_departments ad
                    JOIN user_departments ud ON ud.department_id=ad.department_id
                    WHERE ad.announcement_id=a.id AND ud.user_id=?))
          )
        ORDER BY a.type, a.start_at IS NULL DESC, a.start_at DESC, a.id DESC
        LIMIT 120";
$stm = $pdo->prepare($sql);
$stm->execute([$uid,$uid]);
$rows = $stm->fetchAll();

$out = ['activity'=>[], 'notice'=>[], 'special'=>[]];
foreach ($rows as $r){ $out[$r['type']][] = [
  'id'=>(int)$r['id'],
  'title'=>$r['title'],
  'message'=>$r['message'],
  'start_at'=>$r['start_at'],
  'end_at'=>$r['end_at'],
  'scope'=>$r['scope']
];}
rp_json(['ok'=>true,'items'=>$out]);
