<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login(['admin','manager']);

$in = rp_json_input();
$type   = in_array(($in['type'] ?? ''), ['activity','notice','special'], true) ? $in['type'] : null;
$deptId = isset($in['department_id']) ? (int)$in['department_id'] : 0;
$active = isset($in['active']) ? (bool)$in['active'] : null;

$sql = "SELECT a.* FROM announcements a WHERE 1=1";
$params=[];

if ($type){ $sql.=" AND a.type=?"; $params[]=$type; }
if ($active === true){ $sql.=" AND ( (a.start_at IS NULL OR a.start_at<=NOW()) AND (a.end_at IS NULL OR a.end_at>=NOW()) )"; }
if ($active === false){ $sql.=" AND NOT ( (a.start_at IS NULL OR a.start_at<=NOW()) AND (a.end_at IS NULL OR a.end_at>=NOW()) )"; }

if ($deptId>0){
  $sql.=" AND (a.scope='global' OR (a.scope='department' AND EXISTS(SELECT 1 FROM announcement_departments ad WHERE ad.announcement_id=a.id AND ad.department_id=?)) OR (a.scope='user' AND EXISTS(SELECT 1 FROM announcement_users au JOIN user_departments ud ON ud.user_id=au.user_id WHERE au.announcement_id=a.id AND ud.department_id=?)))";
  $params[]=$deptId; $params[]=$deptId;
}

$sql.=" ORDER BY a.start_at IS NULL DESC, a.start_at DESC, a.id DESC LIMIT 250";
$stm=$pdo->prepare($sql); $stm->execute($params);
$items=$stm->fetchAll();

rp_json(['ok'=>true,'items'=>$items]);
